(function () {
  const createWidget = function () {
    const scriptTag =
      document.currentScript ||
      (function () {
        const scripts = document.getElementsByTagName("script");
        return scripts[scripts.length - 1];
      })();
    const iframeSrc =
      scriptTag.getAttribute("data-src") ||
      "https://cereinsight.cereinsight.com/";

    const styleElement = document.createElement("style");
    styleElement.innerHTML = `
              body {
                  margin: 0;
                  padding: 0;
                  background-color:#fff
                  font-family: Arial, sans-serif;

              }
              #widget-container {
                  position: fixed;
                  height: 80vh; 
                 
                  bottom: 80px;
                  right: 15px;
                  width: 400px;
                  height: 0;
                  background-color: #f1f1f1;
                  border-radius: 10px;
                  overflow: hidden;
                  border-style: none;
                  border:none
                  transition: height 0.3s ease-in-out;
                  z-index: 9999;
                  box-shadow: 5px 5px 5px 5px gray;
                  
              }
              #widget-content::-webkit-scrollbar {
                display: none;
              }
              #widget-content {
                  height: 100%;
                  top: 60px;
                  overflow-y: none;
              }
              iframeWidget {
                  width: 100%;
                  height: 720px; 
                  border: none;
                  position:absolute;
                  bottom: 0px;
                  overflow: hidden;

              }
              #toggle-button {
                  position: fixed;
                  bottom: 10px;
                  right: 15px;
                  background-color: none;
                  color: #fff;
                  padding: 5px 5px;
                  border: none;
                  border-color:"#4B5563" ; 
                  border-radius: 50%; /* Make it circular */
                  cursor: pointer;
                  z-index: 10000;
                  font-size: 30px;
                  display: flex;
                  justify-content: center;
                  align-items: center;
              }
              @media (max-width: 768px) {
                  #widget-container {
                      bottom: 50px;
                      right: 5px;
                      width: 400px;
                      height: 80vh; 
                      border-radius: 10px;
                      overflow: hidden;

                  }
                  #toggle-button {
                      bottom: 5px;
                      right: 5px;
                      font-size: 24px;
                  }
                  iframe {
                      overflow: hidden;

                  }
              }
              @media (max-width: 450px) {
                  #widget-container {
                    overflow: hidden;

                      width: 350px;
        
                  }
        
        
              }
              @media (max-width: 380px) {
                  #widget-container {
                    overflow: hidden;

                      width: 350px;
        
                  }
                  iframe {
                    overflow: hidden;

                      width: 350px
                  }
              }
            `;
    document.head.appendChild(styleElement);

    const widgetContainer = document.createElement("div");
    widgetContainer.id = "widget-container";
    widgetContainer.style.display = "none";
    const iframeContainer = document.createElement("iframe");
    iframeContainer.src = iframeSrc;
    iframeContainer.style.width = "100%";
    iframeContainer.style.height = "100%";
    iframeContainer.style.overflow = "hidden";

    widgetContainer.appendChild(iframeContainer);
    document.body.appendChild(widgetContainer);

    const openButtonImg = `${iframeSrc}/widget/cere.png`;
    const closeButtonImg = `${iframeSrc}/widget/arrow_down.png`;

    const toggleButton = document.createElement("img");
    toggleButton.id = "toggle-button";
    toggleButton.src = openButtonImg;
    toggleButton.style.cursor = "pointer";
    toggleButton.style.width = "70px";
    toggleButton.style.height = "70px";
    toggleButton.style.objectFit = "contain";
    toggleButton.addEventListener("click", toggleWidget);
    document.body.appendChild(toggleButton);

    let widgetOpen = false;
    function toggleWidget() {
      if (widgetOpen) {
        toggleButton.src = openButtonImg;
        widgetContainer.style.display = "none";
        widgetContainer.style.overflow = "hidden";

        widgetOpen = false;
      } else {
        toggleButton.src = closeButtonImg;
        widgetContainer.style.display = "block";
        widgetContainer.style.height = "80vh";
        widgetContainer.style.overflow = "hidden";

        widgetOpen = true;
      }
    }
  };

  createWidget();
})();
